<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\User_Lists\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_user_lists_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Stylesheets
    wp_register_style( 'automatorwp-user-lists-admin-css', AUTOMATORWP_USER_LISTS_URL . 'assets/css/automatorwp-user-lists-admin' . $suffix . '.css', array( ), AUTOMATORWP_USER_LISTS_VER, 'all' );

    // Scripts
    wp_register_script( 'automatorwp-user-lists-admin-js', AUTOMATORWP_USER_LISTS_URL . 'assets/js/automatorwp-user-lists-admin' . $suffix . '.js', array( 'jquery', 'jquery-ui-dialog' ), AUTOMATORWP_USER_LISTS_VER, true );

}
add_action( 'admin_init', 'automatorwp_user_lists_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_user_lists_admin_enqueue_scripts( $hook ) {

    // User Lists list, add and edit screens
    if( $hook === 'automatorwp_page_automatorwp_user_lists' || $hook === 'admin_page_edit_automatorwp_user_lists' ) {
        automatorwp_enqueue_admin_functions_script();

        // Stylesheets
        wp_enqueue_style( 'automatorwp-user-lists-admin-css' );

        // Localize admin script
        wp_localize_script( 'automatorwp-user-lists-admin-js', 'automatorwp_user_lists_admin', array(
            'ajaxurl'           => esc_url( admin_url( 'admin-ajax.php', 'relative' ) ),
            'nonce'             => automatorwp_get_admin_nonce(),
            'no_user_selected'  => __( 'Select a user first.', 'automatorwp-pro' ),
        ) );

        // Scripts
        wp_enqueue_script( 'automatorwp-user-lists-admin-js' );

    }
}
add_action( 'admin_enqueue_scripts', 'automatorwp_user_lists_admin_enqueue_scripts' );
